//******************************************************************************
/*!
	@file		spidrv.h
	@brief		SPI Module Function Header File

				copyright: MITSUMI Electric Co., LTD.
	@attention	none
	@warning	MITSUMI CONFIDENTIAL
*/
//******************************************************************************
/*******************************************************************************
* History : DD.MM.YYYY Version  Description
*         : 24.12.2024 1.0.0.0  First Release
*******************************************************************************/
#ifndef __SPIDRV_H__
#define __SPIDEV_H__

#ifdef __SPIDRV_C__
	#define EXT_SPIDRV
#else
	#define EXT_SPIDRV extern
#endif

//==============================================================================
//{### MODULES USED
//==============================================================================

//==============================================================================
//{### DEFINES AND MACROS
//==============================================================================

	// Numeber of CSB (do not chang)
	#define SPI_CSB_MAX			5
	// 
	// GPIO<n> to which CSB is connected (do not change)
	#define CSB1_GPIO_NO		"26"
	#define CSB2_GPIO_NO		"19"
	#define CSB3_GPIO_NO		"13"
	#define CSB4_GPIO_NO		"6"
	#define CSB5_GPIO_NO		"5"

	// SPI communication settings (do not change)
	//  Only the "SPI_SPEED_HZ" setting can be changed.
	//  The available speed is 6MHz.
	#define SPI_MODE			SPI_MODE_3		 			// SPI MODE=3
	#define SPI_SPEED_HZ		2000000 					// 2MHz
	#define SPI_DELAY_USECS 	0
	#define SPI_SPI_BITS 		8
	#define SPI_CS_CHANGE 		0

	// SPI Buffer Size
	#define SPI_DATA_SIZE		32

//==============================================================================
//{### TYPEDEFS AND STRUCTURES
//==============================================================================
	typedef struct{
		int fd;
		int fd_csb[SPI_CSB_MAX];
		uint8_t mode;
		struct spi_ioc_transfer tr[1];
	} spi_device_t;

//==============================================================================
//{### PROTOTYPE / GLOBAL FUNCTIONS
//==============================================================================
	EXT_SPIDRV int spi_open(spi_device_t *spi_device);
	EXT_SPIDRV int spi_close(spi_device_t *spi_device);

	EXT_SPIDRV int spi_enable(uint8_t devNo, spi_device_t *spi_device);
	EXT_SPIDRV int spi_disable(uint8_t devNo, spi_device_t *spi_device);
	
	EXT_SPIDRV int spi_send_data(uint8_t devNo, spi_device_t *spi_device, uint8_t *txbuf, uint8_t txlen);
	EXT_SPIDRV int spi_receive_data(uint8_t devNo, spi_device_t *spi_device, uint8_t *rxbuf, uint8_t rxlen);
	EXT_SPIDRV int spi_send_receive_data(uint8_t csbNo, spi_device_t *spi_device, uint8_t *txbuf, uint8_t txlen, uint8_t *rxbuf, uint8_t rxlen);
	
	EXT_SPIDRV int getElapsedTimeUs(struct timeval *tvStart, struct timeval *tvUpdate);
	EXT_SPIDRV double getElapsedTime(struct timeval *tvStart, struct timeval *vUpdate);

//==============================================================================
//{### VARIABLES
//==============================================================================
#ifdef __SPIDRV_C__
	char csGpioNo[SPI_CSB_MAX][3] = {CSB1_GPIO_NO, CSB2_GPIO_NO, CSB3_GPIO_NO, CSB4_GPIO_NO, CSB5_GPIO_NO};
#else
	extern char csGpioNo[SPI_CSB_MAX][3];
#endif
	EXT_SPIDRV spi_device_t spi_dev;
	EXT_SPIDRV uint8_t tx_buf[SPI_DATA_SIZE];
	EXT_SPIDRV uint8_t rx_buf[SPI_DATA_SIZE];

#endif 	// __MMS101_SPI_H__

