//******************************************************************************
/*!
	@file		mms101.h
	@brief		MMS101 Sample Source Header File

				copyright: MITSUMI Electric Co., LTD.
	@attention	none
	@warning	MITSUMI CONFIDENTIAL
*/
//******************************************************************************
/*******************************************************************************
* History : DD.MM.YYYY Version  Description
*         : 24.12.2024 1.0.0.0  First Release
*******************************************************************************/
#ifndef __MMS101_H__
#define __MMS101_H__

//==============================================================================
//{### MODULES USED
//==============================================================================
#ifdef __MMS101_C__
	#define EXT_MMS101
#else
	#define EXT_MMS101 extern
#endif

//==============================================================================
//{### DEFINES AND MACROS
//==============================================================================

	// Maximun number of connections (do not change)
	//(=SPI_CSB_MAX@spidrv.h)
	#define MMS101_DEVICE_NUM				5
	
	// Data Rate[usec]
	// Set the interval (time) for obtaining data from MMS10_ SPI1_Conv.BD.
	// Please set it to 1000usec or more.
	#define DATA_RATE_TIME	 				1000

	// Wait time until the first data is available [usec]
	// Please set it to 7500usec or higher.
	#define WAIT_TIME_FOR_STARTUP			10000
	
	// Wait time for temperature sensor value update [usec]
	// Please set it to 7500usec or higher.
	#define WAIT_TIME_FOR_TEMPERATURE		10000

	// INTERVAL Command parameter
	//  Automatically update temperature sensor value.
	//  Update timing is managed by the number of times data is acquired from MMS101.
	//  0              : Do not update automatically
	//  N(=1~10000000) : Update after acquiring data N times
	#define INTERVAL_NUM				 	0

	// Measurement count limi [count] (do not change)
	#define MEAS_NUM_MAX					2000000000

	// Matrix operation data should be right-shifted by 11 bits (do not change)
	// 2048 = 2^11
	#define RIGHT_BIT_SHIFT_11				2048
	
	// 6-axis sensor (do not change)
	#define MMS101_AXIS_NUM					6					// 6-axis senor
	
	// Command Code: MMS101 SPI1 Conv.BD
	#define MMS101_SPI1_CMD_START			0xF0				// 
	#define MMS101_SPI1_CMD_DATA2			0xE2				// 
	#define MMS101_SPI1_CMD_RESTART			0xC0				// 
	#define MMS101_SPI1_CMD_BOOT			0xB0				// 
	#define MMS101_SPI1_CMD_STOP			0xB2				// 
	#define MMS101_SPI1_CMD_RESET			0xB4				// 
	#define MMS101_SPI1_CMD_STATUS			0x80				// 
	#define MMS101_SPI1_CMD_VERSION			0xA2				// 
	#define MMS101_SPI1_CMD_COEFF_FX		0x30				// 
	#define MMS101_SPI1_CMD_COEFF_FY		0x32				// 
	#define MMS101_SPI1_CMD_COEFF_FZ		0x34				// 
	#define MMS101_SPI1_CMD_COEFF_MX		0x36				// 
	#define MMS101_SPI1_CMD_COEFF_MY		0x38				// 
	#define MMS101_SPI1_CMD_COEFF_MZ		0x3A				// 
	#define MMS101_SPI1_CMD_INTERVAL		0x44				// 

	// State ID:MMS101 SPI1 Conv.BD
	#define MMS101_SPI1_STT_IDLE			0x00				// 
	#define MMS101_SPI1_STT_STANDBY			0x01				// 
	#define MMS101_SPI1_STT_BOOT			0x02				// 
	#define MMS101_SPI1_STT_READY			0x03				// 
	#define MMS101_SPI1_STT_MEASURE			0x04				// 
	#define MMS101_SPI1_STT_RESET			0x05				// 
	#define MMS101_SPI1_STT_ERROR			0xFF				// 

//==============================================================================
//{### TYPEDEFS AND STRUCTURES
//==============================================================================
	// Structure for mms101 data
	typedef struct{
		uint8_t channelEnable;									// Ch enable
		uint8_t statusCode;										// Status code (@MMS101 SPI1 Conv.BD)
		uint16_t measureStatus;									// Measure status (@MMS101 SPI1 Conv.BD)
		uint8_t stateID;										// State ID (@MMS101 SPI1 ConvBD)
		uint8_t hwVer[2];										// Hardware version (@MMS101 SPI1 Conv.BD)
		uint8_t fwVer[4];										// Firmware version (@MMS101 SPI1 Conv.BD)
		uint8_t bitShift;										// Bit shift value
		int32_t coeff[MMS101_AXIS_NUM][MMS101_AXIS_NUM];		// Matrix operation correction coefficient
		int32_t adc[MMS101_AXIS_NUM];							// AD value
		int32_t matrix[MMS101_AXIS_NUM];						// Matrix operation data
	}mms101_data_t;

//==============================================================================
//{### PROTOTYPE / GLOBAL FUNCTIONS
//==============================================================================
	EXT_MMS101 int mms101_spi1_start(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_data2(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_restart(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_boot(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_stop(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_reset(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_status(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_version(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_coeff(uint8_t devNo);
	EXT_MMS101 int mms101_spi1_interval(uint8_t devNo);
	
	EXT_MMS101 void mms101_calc_matrix(uint8_t devNo);
	
	EXT_MMS101 void mms101_usage(void);
	
//==============================================================================
//{### VARIABLES
//==============================================================================
	EXT_MMS101 mms101_data_t mms101_data[MMS101_DEVICE_NUM]; 				// Structure of mms101 data
	EXT_MMS101 struct timeval startTime;
	EXT_MMS101 struct timeval preGetTime;
	EXT_MMS101 uint8_t  temperatureCorrectionRequest;
	EXT_MMS101 uint8_t  measureStopRequest;

#endif 	// __MMS101_H__

